<?php
session_start();

// --- CONFIG: Allowed login credentials ---
$valid_username = "admin";
$valid_password = "password123";

// --- Database Credentials ---
$servername = "localhost";
$username = "prudzzwy_pest";
$password = "prudzzwy_pest";
$dbname = "prudzzwy_pest";

// --- Stripe API Keys ---
// Make sure you have the Stripe library installed via Composer or manually.
require_once 'stripe-php/init.php';
// IMPORTANT: Your secret key must be set here to process payments.
\Stripe\Stripe::setApiKey('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'); 

// --- Handle successful Stripe payment ---
if (isset($_GET['session_id'])) {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }
    
    try {
        $checkout_session = \Stripe\Checkout\Session::retrieve($_GET['session_id']);
        
        // Retrieve booking data from the session
        // This assumes you stored the booking data in the session before redirecting to Stripe
        if (isset($_SESSION['booking_data'])) {
            $booking_data = $_SESSION['booking_data'];
            
            // Check if payment was successful and booking is not already saved
            if ($checkout_session->payment_status === 'paid' && !isset($_SESSION['booking_saved'])) {
                
                // Prepare the SQL statement to insert booking data
                $sql = "INSERT INTO bookings (services, addons, date, time, worker_name, contact_name, contact_email, contact_phone, contact_address, contact_location_link, payment_method, total_price, instructions)
                        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                
                $stmt = $conn->prepare($sql);
                $payment_method = 'Stripe';
                
                $stmt->bind_param("sssssssssssss",
                    $booking_data['services'],
                    $booking_data['addons'],
                    $booking_data['date'],
                    $booking_data['time'],
                    $booking_data['worker_name'],
                    $booking_data['contact_name'],
                    $booking_data['contact_email'],
                    $booking_data['contact_phone'],
                    $booking_data['contact_address'],
                    $booking_data['contact_location_link'],
                    $payment_method,
                    $booking_data['total_price'],
                    $booking_data['instructions']
                );
                
                if ($stmt->execute()) {
                    $_SESSION['booking_saved'] = true; // Prevents duplicate bookings
                    // Unset session data to clean up
                    unset($_SESSION['booking_data']);
                    echo "Booking successful! Your details have been saved.";
                } else {
                    echo "Error: Could not save booking details. " . $stmt->error;
                }
                
                $stmt->close();
            }
        }
    } catch (\Stripe\Exception\ApiErrorException $e) {
        echo "Error retrieving Stripe session: " . $e->getMessage();
    }
    $conn->close();
}

// --- Handle form submission (Cash on Delivery or Stripe) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_booking'])) {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Database connection failed: " . $conn->connect_error);
    }

    $services_json = json_encode($_POST['services']);
    $addons_json = json_encode($_POST['addons']);
    $date = $_POST['date'];
    $time = $_POST['time'];
    $worker_name = $_POST['worker'];
    $contact_name = $_POST['contact_name'];
    $contact_email = $_POST['contact_email'];
    $contact_phone = $_POST['contact_phone'];
    $contact_address = $_POST['contact_address'];
    $contact_location_link = $_POST['contact_location_link'];
    $payment_method = $_POST['payment_method'];
    $total_price = $_POST['total_price'];
    $instructions = $_POST['instructions'];

    if ($payment_method === 'cash_on_delivery') {
        // --- Insert for Cash on Delivery ---
        $sql = "INSERT INTO bookings (services, addons, date, time, worker_name, contact_name, contact_email, contact_phone, contact_address, contact_location_link, payment_method, total_price, instructions)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssssssssss", $services_json, $addons_json, $date, $time, $worker_name, $contact_name, $contact_email, $contact_phone, $contact_address, $contact_location_link, $payment_method, $total_price, $instructions);

        if ($stmt->execute()) {
            echo "Booking successful! Your details have been saved.";
        } else {
            echo "Error: Could not save booking details. " . $stmt->error;
        }
        $stmt->close();

    } elseif ($payment_method === 'stripe') {
        // --- Create Stripe Checkout Session ---
        // Store booking data in a session to be retrieved after payment
        $_SESSION['booking_data'] = [
            'services' => $services_json,
            'addons' => $addons_json,
            'date' => $date,
            'time' => $time,
            'worker_name' => $worker_name,
            'contact_name' => $contact_name,
            'contact_email' => $contact_email,
            'contact_phone' => $contact_phone,
            'contact_address' => $contact_address,
            'contact_location_link' => $contact_location_link,
            'total_price' => $total_price,
            'instructions' => $instructions,
        ];

        // Create line items for the Stripe Checkout Session
        $line_items = [
            [
                'price_data' => [
                    'currency' => 'aed',
                    'product_data' => [
                        'name' => 'Pest Control Services',
                    ],
                    'unit_amount' => $total_price * 100, // Amount in cents
                ],
                'quantity' => 1,
            ],
        ];

        try {
            $checkout_session = \Stripe\Checkout\Session::create([
                'payment_method_types' => ['card'],
                'line_items' => $line_items,
                'mode' => 'payment',
                'success_url' => "https://services.prudentpestservices.com/pest/booking_system.php?session_id={CHECKOUT_SESSION_ID}", 
                'cancel_url' => "https://services.prudentpestservices.com/pest/booking_system.php",
            ]);
            
            header("Location: " . $checkout_session->url);
            exit;
        } catch (Exception $e) {
            echo "Stripe Error: " . $e->getMessage();
        }
    }
    
    $conn->close();
}

// --- Admin Login & View Bookings Logic ---
// ... (The rest of your code for admin login and viewing bookings remains the same)

// This part of the code is for handling the admin login and displaying the booking records.
// It is kept as is from your original file.
if (isset($_POST['username']) && isset($_POST['password'])) {
    if ($_POST['username'] === $valid_username && $_POST['password'] === $valid_password) {
        $_SESSION['logged_in'] = true;
    } else {
        $error = "Invalid username or password.";
    }
}

if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

function displayBookingRecords($conn) {
    if ($conn->connect_error) {
        echo "<div class='empty-message'>Database connection failed: " . $conn->connect_error . "</div>";
        return;
    }

    $sql = "SELECT * FROM bookings ORDER BY created_at DESC";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        echo "<table>";
        echo "<tr>";
        echo "<th>ID</th>";
        echo "<th>Services</th>";
        echo "<th>Add-ons</th>";
        echo "<th>Date & Time</th>";
        echo "<th>Worker</th>";
        echo "<th>Client Name</th>";
        echo "<th>Contact</th>";
        echo "<th>Address</th>";
        echo "<th>Location Link</th>";
        echo "<th>Payment Method</th>";
        echo "<th>Total Price</th>";
        echo "<th>Instructions</th>";
        echo "<th>Booked At</th>";
        echo "<th>Actions</th>";
        echo "</tr>";
        
        while($row = $result->fetch_assoc()) {
            $services_json = json_decode($row['services'], true);
            $addons_json = json_decode($row['addons'], true);

            $booking_data_for_js = [
                'ID' => $row['id'],
                'Services' => !empty($services_json) ? implode(', ', array_column($services_json, 'name')) : '-',
                'Add-ons' => !empty($addons_json) ? implode(', ', array_column($addons_json, 'name')) : '-',
                'Date' => $row['date'],
                'Time' => $row['time'],
                'Worker' => $row['worker_name'],
                'Client Name' => $row['contact_name'],
                'Contact' => $row['contact_email'] . ' / ' . $row['contact_phone'],
                'Address' => $row['contact_address'],
                'Location Link' => $row['contact_location_link'],
                'Payment Method' => $row['payment_method'],
                'Total Price' => 'AED ' . $row['total_price'],
                'Instructions' => $row['instructions'],
                'Booked At' => $row['created_at']
            ];
            $json_data = htmlspecialchars(json_encode($booking_data_for_js), ENT_QUOTES, 'UTF-8');
            
            $services_list = [];
            if ($services_json) {
                foreach ($services_json as $service) {
                    $services_list[] = htmlspecialchars($service['name']) . " (AED " . htmlspecialchars($service['price']) . ")";
                }
            }
            
            $addons_list = [];
            if ($addons_json) {
                foreach ($addons_json as $addon) {
                    $addons_list[] = htmlspecialchars($addon['name']) . " (AED " . htmlspecialchars($addon['price']) . ")";
                }
            }

            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['id']) . "</td>";
            echo "<td>" . (!empty($services_list) ? implode('<br>', $services_list) : '-') . "</td>";
            echo "<td>" . (!empty($addons_list) ? implode('<br>', $addons_list) : '-') . "</td>";
            echo "<td>" . htmlspecialchars($row['date']) . "<br>" . htmlspecialchars($row['time']) . "</td>";
            echo "<td>" . htmlspecialchars($row['worker_name']) . "</td>";
            echo "<td>" . htmlspecialchars($row['contact_name']) . "</td>";
            echo "<td>" . htmlspecialchars($row['contact_email']) . "<br>" . htmlspecialchars($row['contact_phone']) . "</td>";
            echo "<td>" . htmlspecialchars($row['contact_address']) . "</td>";
            echo "<td>";
            if (!empty($row['contact_location_link'])) {
                echo "<a href='" . htmlspecialchars($row['contact_location_link']) . "' target='_blank'>View Location</a>";
            } else {
                echo "-";
            }
            echo "</td>";
            echo "<td>" . htmlspecialchars($row['payment_method']) . "</td>";
            echo "<td>AED " . htmlspecialchars($row['total_price']) . "</td>";
            echo "<td><pre>" . htmlspecialchars($row['instructions']) . "</pre></td>";
            echo "<td>" . htmlspecialchars($row['created_at']) . "</td>";
            echo "<td><button onclick='copyBookingDetails(this, " . $json_data . ")' class='action-link'>Copy Details</button></td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<div class='empty-message'>No bookings found.</div>";
    }
}

if (isset($_GET['action']) && $_GET['action'] === 'get_records') {
    $conn = new mysqli($servername, $username, $password, $dbname);
    displayBookingRecords($conn);
    $conn->close();
    exit;
}

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Montserrat', sans-serif; background-color: #f3f4f6; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .login-box { background: #fff; padding: 2rem; border-radius: 1rem; box-shadow: 0 10px 20px rgba(0,0,0,0.1); width: 350px; }
        h2 { text-align: center; margin-bottom: 1rem; color: #3b82f6; }
        input { width: 100%; padding: 0.8rem; margin: 0.5rem 0; border: 1px solid #ddd; border-radius: 0.5rem; }
        button { width: 100%; padding: 0.8rem; background: #3b82f6; color: #fff; border: none; border-radius: 0.5rem; font-weight: bold; cursor: pointer; }
        .error { color: red; text-align: center; margin-bottom: 1rem; }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Admin Login</h2>
        <?php if (isset($error)) echo "<div class='error'>$error</div>"; ?>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
        </form>
    </div>
</body>
</html>
<?php
exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Records</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Montserrat', sans-serif; background-color: #f3f4f6; color: #1f2937; padding: 2rem; }
        .container { max-width: 1200px; margin: 0 auto; background-color: #ffffff; padding: 2rem; border-radius: 1rem; box-shadow: 0 10px 20px rgba(0,0,0,0.05); overflow-x: auto; }
        h1 { text-align: center; color: #3b82f6; margin-bottom: 2rem; }
        table { width: 100%; border-collapse: collapse; margin-top: 1rem; }
        th, td { padding: 1rem; text-align: left; border-bottom: 1px solid #e5e7eb; white-space: nowrap; }
        th { background-color: #eff6ff; font-weight: 600; color: #3b82f6; }
        tr:hover { background-color: #f9fafb; }
        .empty-message { text-align: center; font-style: italic; color: #6b7280; padding: 2rem; }
        pre { background-color: #e5e7eb; padding: 0.5rem; border-radius: 0.5rem; white-space: pre-wrap; word-wrap: break-word; font-family: 'Montserrat', sans-serif; font-size: 0.9rem; }
        .logout { text-align: right; margin-bottom: 1rem; }
        .logout a { color: #ef4444; font-weight: bold; text-decoration: none; }
        .action-link { display: inline-block; padding: 0.4rem 0.8rem; background-color: #10b981; color: white !important; text-decoration: none; border-radius: 0.3rem; font-size: 0.9rem; text-align: center; border: none; cursor: pointer; }
        .action-link:hover { background-color: #059669; }
    </style>
</head>
<body>

<div class="container">
    <div class="logout">
        <a href="?logout=1">Logout</a>
    </div>
    <h1>All Booking Records</h1>
    <div id="booking-records-container">
        <?php
        $conn = new mysqli($servername, $username, $password, $dbname);
        displayBookingRecords($conn);
        $conn->close();
        ?>
    </div>
</div>

<script>
    function copyBookingDetails(button, data) {
        const textToCopy = `
*Booking Details*
-------------------------
*Booking ID:* ${data.ID}
*Client Name:* ${data['Client Name']}
*Contact:* ${data.Contact}
*Address:* ${data.Address}
*Location Link:* ${data['Location Link'] || 'N/A'}

*Date:* ${data.Date}
*Time:* ${data.Time}
*Worker:* ${data.Worker}

*Services:* ${data.Services}
*Add-ons:* ${data['Add-ons']}

*Total Price:* ${data['Total Price']}
*Payment Method:* ${data['Payment Method']}

*Instructions:*
${data.Instructions}

*Booked At:* ${data['Booked At']}
-------------------------
        `.trim().replace(/(\r\n|\n|\r)/gm, "\n");

        navigator.clipboard.writeText(textToCopy).then(() => {
            const originalText = button.innerText;
            button.innerText = 'Copied!';
            button.disabled = true;
            setTimeout(() => {
                button.innerText = originalText;
                button.disabled = false;
            }, 2000);
        }).catch(err => {
            console.error('Failed to copy text: ', err);
            alert('Could not copy details. Please try again or copy manually.');
        });
    }

    function fetchLatestRecords() {
        fetch('<?php echo $_SERVER['PHP_SELF']; ?>?action=get_records')
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.text();
            })
            .then(html => {
                document.getElementById('booking-records-container').innerHTML = html;
            })
            .catch(error => {
                console.error('Error fetching booking records:', error);
            });
    }

    setInterval(fetchLatestRecords, 10000);
</script>

</body>
</html>