<?php
header('Content-Type: text/html; charset=utf-8');
// Prevent browser caching to ensure the latest booking data is always loaded
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
date_default_timezone_set('Asia/Dubai');
session_start();

// --- PHPMailer Integration ---
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
// IMPORTANT: Download PHPMailer from https://github.com/PHPMailer/PHPMailer
// Extract the ZIP, and place the 'src' folder in the same directory as this file.
require 'src/Exception.php';
require 'src/PHPMailer.php';
require 'src/SMTP.php';

// --- Stripe Integration (For Shared Hosting like Namecheap) ---
// IMPORTANT: Composer aksar shared hosting par nahi hota, isliye yeh manual tareeqa follow karein:
// 1. Is link par jayein: https://github.com/stripe/stripe-php/releases
// 2. Latest version ki 'stripe-php.zip' file download karein.
// 3. ZIP file ko extract karein. Aapko 'stripe-php' naam ka folder milega.
// 4. Is 'stripe-php' folder ko apni website par wahan upload karein jahan yeh 'booking_system.php' file hai.
require 'stripe-php/init.php';

// Apni Stripe Secret Key yahan daalein.
\Stripe\Stripe::setApiKey('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');

// =========================================================================
//  PHP SCRIPT TO HANDLE DATABASE CONNECTION AND FORM SUBMISSION
// =========================================================================

$servername = "localhost";
$username = "prudzzwy_pest";
$password = "prudzzwy_pest";
$dbname = "prudzzwy_pest";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}
$conn->query("SET time_zone = '+04:00'");

// --- Auto-add column if missing ---
function addColumnIfMissing($conn, $table, $column, $type) {
    $result = $conn->query("SHOW COLUMNS FROM `$table` LIKE '$column'");
    if ($result->num_rows == 0) {
        $conn->query("ALTER TABLE `$table` ADD `$column` $type");
    }
}
// Ensure 'contact_location_link' exists
addColumnIfMissing($conn, 'bookings', 'contact_location_link', 'VARCHAR(255)');
// Ensure 'worker_id' exists for robust matching
addColumnIfMissing($conn, 'bookings', 'worker_id', 'VARCHAR(50)');
// Ensure 'reference_number' exists for booking tracking
addColumnIfMissing($conn, 'bookings', 'reference_number', 'VARCHAR(50) NULL UNIQUE');
// Ensure 'stripe_payment_intent_id' exists for tracking online payments
addColumnIfMissing($conn, 'bookings', 'stripe_payment_intent_id', 'VARCHAR(255) NULL');

// --- Function to fetch all current and future bookings ---
function getBookedSlots($conn) {
    $bookedSlots = [];
    // Fetch worker_id for robust matching
    // Format the time to match the frontend format (e.g., 08:00 AM)
    $sql_fetch_bookings = "SELECT date, DATE_FORMAT(time, '%h:%i %p') as time, worker_id FROM bookings WHERE date >= CURDATE()";
    $result_bookings = $conn->query($sql_fetch_bookings);
    if ($result_bookings) {
        while($row = $result_bookings->fetch_assoc()) {
            $date = trim($row['date']);
            $time = trim($row['time']);
            $workerId = trim($row['worker_id']);

            if (empty($date) || empty($time) || empty($workerId)) continue; // Skip invalid rows

            if (!isset($bookedSlots[$date])) {
                $bookedSlots[$date] = [];
            }
            if (!isset($bookedSlots[$date][$time])) {
                // Use 'worker_ids' for clarity
                $bookedSlots[$date][$time] = ['count' => 0, 'worker_ids' => []];
            }
            $bookedSlots[$date][$time]['count']++;
            $bookedSlots[$date][$time]['worker_ids'][] = $workerId;
        }
    }
    return $bookedSlots;
}

// --- New: Handle AJAX request to fetch latest slots ---
if (isset($_GET['action']) && $_GET['action'] === 'get_slots') {
    header('Content-Type: application/json');
    // Re-iterate caching headers for this specific API-like response
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Pragma: no-cache");

    $currentBookedSlots = getBookedSlots($conn);
    echo json_encode($currentBookedSlots);
    $conn->close();
    exit();
}

// --- New: Handle AJAX request to create a Stripe Payment Intent ---
if (isset($_GET['action']) && $_GET['action'] === 'create-payment-intent') {
    header('Content-Type: application/json');
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (empty($data) || !isset($data['services']) || !isset($data['addons'])) {
        echo json_encode(['error' => 'Invalid data for payment.']);
        exit();
    }

    // --- Server-side calculation of total price for security ---
    $totalPrice = 0;
    foreach ($data['services'] as $service) {
        $totalPrice += (int)$service['price'];
    }
    foreach ($data['addons'] as $addon) {
        $totalPrice += (int)$addon['price'];
    }

    // Apply 5% discount for online payment
    $discountAmount = $totalPrice * 0.05;
    $finalAmount = $totalPrice - $discountAmount;
    if ($finalAmount < 1) $finalAmount = 1; // Stripe requires a minimum amount (e.g., 1 AED)

    try {
        $paymentIntent = \Stripe\PaymentIntent::create([
            'amount' => round($finalAmount * 100), // Amount in fils (AED * 100), rounded to nearest integer
            'currency' => 'aed',
            'automatic_payment_methods' => ['enabled' => true],
        ]);

        echo json_encode(['clientSecret' => $paymentIntent->client_secret, 'finalAmount' => $finalAmount]);
    } catch (Error $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit();
}

// Check if a POST request was made to save the booking data
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // This part remains for handling the booking submission
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if (empty($data)) {
        echo json_encode(['success' => false, 'message' => 'No data received.']);
        $conn->close();
        exit();
    }

    // Sanitize and extract data
    $services = json_encode($data['services']);
    $addons = json_encode($data['addons']);
    $date = $conn->real_escape_string($data['date']);
    $time = $conn->real_escape_string($data['time']);
    $worker_name = $conn->real_escape_string($data['worker']['name']);
    $worker_id = $conn->real_escape_string($data['worker']['id']);
    $contact_name = $conn->real_escape_string($data['contactDetails']['name']);
    $contact_address = $conn->real_escape_string($data['contactDetails']['address']);
    $contact_email = $conn->real_escape_string($data['contactDetails']['email']);
    $contact_phone = $conn->real_escape_string($data['contactDetails']['phone']);
    $contact_location_link = isset($data['contactDetails']['locationLink']) ? $conn->real_escape_string($data['contactDetails']['locationLink']) : '';
    $payment_method = $conn->real_escape_string($data['paymentMethod']);
    $instructions = $conn->real_escape_string($data['instructions']);
    $stripe_payment_intent_id = isset($data['paymentIntentId']) ? $conn->real_escape_string($data['paymentIntentId']) : null;

    // --- Recalculate price on server for security ---
    $original_total_price = 0;
    foreach ($data['services'] as $service) { $original_total_price += (int)$service['price']; }
    foreach ($data['addons'] as $addon) { $original_total_price += (int)$addon['price']; }

    // Apply 5% discount if payment was made via Stripe and save the final price
    $final_price = ($payment_method === 'Online Payment (Stripe)' && !empty($stripe_payment_intent_id)) ? $original_total_price * 0.95 : $original_total_price;
    if ($final_price < 0) $final_price = 0;
    $maxBookingsPerSlot = 3;

    // --- SERVER-SIDE VALIDATION ---

    // 1. Check if the specific worker is already booked for that slot
    $stmt_check_worker = $conn->prepare("SELECT COUNT(*) as count FROM bookings WHERE date = ? AND time = ? AND worker_id = ?");
    $stmt_check_worker->bind_param("sss", $date, $time, $worker_id);
    $stmt_check_worker->execute();
    $result_worker = $stmt_check_worker->get_result()->fetch_assoc();
    $stmt_check_worker->close();

    if ($result_worker['count'] > 0) {
        $updatedBookedSlots = getBookedSlots($conn);
        echo json_encode([
            'success' => false, 
            'message' => 'We Apologies, Selected Professional already Booked at your Desired time slot Please choose any other professional for this time slot',
            'updatedSlots' => $updatedBookedSlots
        ]);
        $conn->close();
        exit();
    }

    // 2. Check total bookings for the slot
    $stmt_check_slot = $conn->prepare("SELECT COUNT(*) as count FROM bookings WHERE date = ? AND time = ?");
    $stmt_check_slot->bind_param("ss", $date, $time);
    $stmt_check_slot->execute();
    $result_slot = $stmt_check_slot->get_result()->fetch_assoc();
    $stmt_check_slot->close();

    if ($result_slot['count'] >= $maxBookingsPerSlot) {
        $updatedBookedSlots = getBookedSlots($conn);
        echo json_encode([
            'success' => false, 
            'message' => 'Sorry, this time slot just became fully booked. Please choose another time.',
            'updatedSlots' => $updatedBookedSlots
        ]);
        $conn->close();
        exit();
    }

    // --- New: Server-side validation for Stripe payment ---
    if ($payment_method === 'Online Payment (Stripe)') {
        if (empty($stripe_payment_intent_id)) {
            echo json_encode(['success' => false, 'message' => 'Payment confirmation failed. Missing payment ID.']);
            $conn->close();
            exit();
        }
        try {
            $paymentIntent = \Stripe\PaymentIntent::retrieve($stripe_payment_intent_id);
            // CRITICAL: Verify payment status AND amount against server-calculated price
            if ($paymentIntent->status !== 'succeeded' || $paymentIntent->amount !== round($final_price * 100)) {
                throw new Exception('Payment verification failed. Status or amount mismatch.');
            }
        } catch (Exception $e) {
            error_log("Stripe Verification Error: " . $e->getMessage());
            echo json_encode(['success' => false, 'message' => 'There was an issue verifying your payment. Please contact support.']);
            $conn->close();
            exit();
        }
    }

    // --- If validation passes, proceed with insertion ---


    // Prepare and execute the SQL statement
    $sql = "INSERT INTO bookings (
        services, addons, date, time, worker_name, worker_id,
        contact_name, contact_address, contact_email, contact_phone, 
        contact_location_link, payment_method, instructions, total_price, stripe_payment_intent_id
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssssssssds",
        $services, $addons, $date, $time, $worker_name, $worker_id,
        $contact_name, $contact_address, $contact_email,
        $contact_phone, $contact_location_link, $payment_method, $instructions, $final_price, $stripe_payment_intent_id
    );

    if ($stmt->execute()) {
        // --- Generate and save reference number ---
        $booking_id = $stmt->insert_id; // Get the ID of the new booking
        $reference_number = 'PPS-' . date('Ymd') . '-' . $booking_id;

        // Update the booking with the reference number
        $stmt_update_ref = $conn->prepare("UPDATE bookings SET reference_number = ? WHERE id = ?");
        if ($stmt_update_ref) {
            $stmt_update_ref->bind_param("si", $reference_number, $booking_id);
            $stmt_update_ref->execute();
            $stmt_update_ref->close();
        }
        // --- End reference number generation ---

        // --- SEND CONFIRMATION EMAIL ---
        $mail = new PHPMailer(true);

        try {
            // Server settings for sending email.
            // Debug is off. Errors will be caught and shown to the user via JSON.
            $mail->SMTPDebug = 0;
            //Server settings
            $mail->isSMTP();
            $mail->Host       = 'server244.web-hosting.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'mail@prudentpestservices.com';
            $mail->Password   = 'Askmyname@123'; // !!! IMPORTANT: YAHAN APNA EMAIL PASSWORD LIKHEIN !!!
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // SSL
            $mail->Port       = 465;

            //Recipients
            $mail->setFrom('mail@prudentpestservices.com', 'Prudent Pest Services');
            $mail->addAddress($contact_email, $contact_name); // Customer ko email jaegi
            $mail->addBCC('mail@prudentpestservices.com'); // Apne aap ko copy bhejne ke liye

            // Content
            $mail->isHTML(true);
            $mail->Subject = 'Your Booking Confirmation with Prudent Pest Services (Ref: ' . $reference_number . ')';

            // Email ka poora content
            $emailBody = "<h1>Booking Confirmed!</h1>";
            $emailBody .= "<p>Dear " . htmlspecialchars($contact_name) . ",</p>";
            $emailBody .= "<p>Thank you for booking with Prudent Pest Services. Your service is confirmed. Here are the details of your booking:</p>";
            $emailBody .= "<hr><h2>Booking Summary</h2>";
            $emailBody .= "<p><strong>Booking Reference:</strong> " . htmlspecialchars($reference_number) . "</p>";
            $emailBody .= "<p><strong>Date:</strong> " . htmlspecialchars($date) . "</p>";
            $emailBody .= "<p><strong>Time:</strong> " . htmlspecialchars($time) . "</p>";
            $emailBody .= "<p><strong>Professional:</strong> " . htmlspecialchars($worker_name) . "</p>";
            
            $emailBody .= "<h3>Services:</h3><ul>";
            $decoded_services = json_decode($services, true);
            foreach ($decoded_services as $service) {
                $category_display = isset($service['category']) && !empty($service['category']) ? htmlspecialchars($service['category']) . ' - ' : '';
                $emailBody .= "<li>" . $category_display . htmlspecialchars($service['name']) . " - AED " . htmlspecialchars($service['price']) . "</li>";
            }
            $emailBody .= "</ul>";

            $decoded_addons = json_decode($addons, true);
            if (!empty($decoded_addons)) {
                $emailBody .= "<h3>Add-ons:</h3><ul>";
                foreach ($decoded_addons as $addon) {
                    $emailBody .= "<li>" . htmlspecialchars($addon['name']) . " - AED " . htmlspecialchars($addon['price']) . "</li>";
                }
                $emailBody .= "</ul>";
            }

            $emailBody .= "<hr>";
            $emailBody .= "<p><strong>Total Price:</strong> AED " . htmlspecialchars($final_price) . "</p>";
            $emailBody .= "<p><strong>Payment Method:</strong> " . htmlspecialchars($payment_method) . "</p>";
            $emailBody .= "<hr>";

            $emailBody .= "<h3>Your Details:</h3>";
            $emailBody .= "<p><strong>Address:</strong> " . htmlspecialchars($contact_address) . "</p>";
            $emailBody .= "<p><strong>Email:</strong> " . htmlspecialchars($contact_email) . "</p>";
            $emailBody .= "<p><strong>Phone:</strong> " . htmlspecialchars($contact_phone) . "</p>";
            $emailBody .= "<br><p>We look forward to serving you.</p><p>Best regards,<br>The Prudent Pest Services Team</p>";
            $mail->Body = $emailBody;
            $mail->send();
            echo json_encode(['success' => true, 'message' => 'Booking confirmed! A confirmation email has been sent.']);
        } catch (Exception $e) {
            // Log the error for the admin
            error_log("PHPMailer Error: {$mail->ErrorInfo}");
            // Send a detailed error back to the JavaScript to be shown in an alert.
            echo json_encode([
                'success' => true, // Booking was saved, but email failed.
                'email_error' => "Booking saved, but email failed. Server error: " . $mail->ErrorInfo
            ]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Error saving booking: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://js.stripe.com/v3/"></script>
    <title>Service Booking Form</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #3b82f6;
            --primary-light: #eff6ff;
            --text-color: #1f2937;
            --sub-text-color: #6b7280;
            --bg-color: #f3f4f6;
            --card-bg: #ffffff;
            --border-color: #e5e7eb;
            --shadow-light: rgba(0, 0, 0, 0.05);
            --transition-speed: 0.4s;
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Montserrat', sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .main-container {
            display: flex;
            width: 100%;
            max-width: 1300px;
            height: 90vh;
            background-color: var(--card-bg);
            border-radius: 2rem;
            box-shadow: 0 25px 50px -12px var(--shadow-light);
            overflow: hidden;
        }

        .main-content {
            flex: 2.5;
            display: flex;
            flex-direction: column;
            padding: 2.5rem;
            overflow: hidden;
            position: relative;
        }

        .form-header {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .back-btn {
            background: none;
            border: none;
            color: var(--sub-text-color);
            font-size: 2rem;
            cursor: pointer;
            transition: color var(--transition-speed);
        }

        .back-btn:hover {
            color: var(--primary-color);
        }
        
        .step-info {
            flex-grow: 1;
        }
        
        .step-info h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--text-color);
            margin-bottom: 0.25rem;
        }
        
        .progress-bar-container {
            width: 100%;
            height: 0.5rem;
            background-color: var(--border-color);
            border-radius: 0.25rem;
        }

        .progress-bar-fill {
            height: 100%;
            width: 0%;
            background-color: var(--primary-color);
            border-radius: 0.25rem;
            transition: width var(--transition-speed) cubic-bezier(0.2, 0.8, 0.2, 1);
        }
        
        .form-steps {
            flex: 1;
            position: relative;
            overflow: hidden;
            padding-bottom: 5rem;
        }

        .form-step {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transition: transform 0.6s cubic-bezier(0.65, 0.05, 0.36, 1), opacity 0.6s ease-in-out;
            transform: translateX(100%);
            opacity: 0;
            overflow-y: auto;
            padding-right: 1rem;
            display: flex;
            flex-direction: column;
        }
        
        .form-step::-webkit-scrollbar {
            width: 8px;
        }
        
        .form-step::-webkit-scrollbar-thumb {
            background-color: #d1d5db;
            border-radius: 4px;
        }

        .form-step.active {
            transform: translateX(0);
            opacity: 1;
            position: relative;
        }
        
        .step-content-heading {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .step-content-subtitle {
            font-size: 1rem;
            color: var(--sub-text-color);
            margin-bottom: 2rem;
        }

        /* Step 1: Main Services */
        .categories {
            display: flex;
            gap: 0.75rem;
            margin-bottom: 1.5rem;
            flex-wrap: nowrap;
            overflow-x: auto;
            padding-bottom: 43px;
            position: sticky;
            top: -1px;
            background-color: var(--card-bg);
            z-index: 2;
            padding-top: 1rem;
            -webkit-overflow-scrolling: touch;
            scrollbar-width: none;
        }

        .category-tab {
            
    height: 43px;
            padding: 0.75rem 1.5rem;
            border-radius: 2rem;
            font-size: 0.9rem;
            font-weight: 500;
            color: var(--sub-text-color);
            background-color: var(--bg-color);
            cursor: pointer;
            transition: all var(--transition-speed);
            flex-shrink: 0;
        }

        .category-tab.active {
            background-color: var(--primary-color);
            color: var(--card-bg);
            box-shadow: 0 4px 14px rgba(59, 130, 246, 0.25);
        }

        .service-category {
            padding-bottom: 2rem;
            scroll-margin-top: 5rem; /* Offset for sticky category bar */
        }

        .service-category h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        .service-card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 1.5rem;
            padding: 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all var(--transition-speed);
            margin-bottom: 1rem;
            cursor: pointer;
        }
        
        .service-card:hover {
            box-shadow: 0 10px 20px -5px var(--shadow-light);
            transform: translateY(-0.25rem);
        }

        .service-info {
            display: flex;
            flex-direction: column;
        }

        .service-name {
            font-weight: 600;
            font-size: 1rem;
            color: var(--text-color);
        }
        
        .service-description {
            font-size: 0.85rem;
            color: var(--sub-text-color);
            margin-top: 0.25rem;
        }

        .service-price {
            color: var(--sub-text-color);
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }
        
        .add-button {
            background-color: var(--primary-light);
            color: var(--primary-color);
            border: none;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            font-size: 1.5rem;
            font-weight: 500;
            cursor: pointer;
            transition: all var(--transition-speed);
        }

        .add-button:hover {
            background-color: var(--primary-color);
            color: var(--card-bg);
        }

        /* Step 2: Add-ons */
        .addon-card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 1.5rem;
            padding: 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all var(--transition-speed);
            margin-bottom: 1rem;
            cursor: pointer;
        }

        .addon-card.selected {
            border-color: var(--primary-color);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
            background-color: var(--primary-light);
        }
        .addon-info {
            display: flex;
            flex-direction: column;
        }
        .addon-name {
            font-weight: 600;
            font-size: 1rem;
            color: var(--text-color);
        }
        .addon-price {
            font-size: 0.9rem;
            color: var(--sub-text-color);
            margin-top: 0.25rem;
        }

        /* Step 3: Appointment */
        .calendar {
            display: grid;
            grid-template-columns: repeat(7, 1fr);
            gap: 0.75rem;
            text-align: center;
            margin-bottom: 2rem;
        }

        .day {
            padding: 1rem 0;
            border-radius: 1rem;
            cursor: pointer;
            background-color: var(--bg-color);
            transition: all var(--transition-speed);
        }
        
        .day.selected {
            background-color: var(--primary-color);
            color: var(--card-bg);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
        }

        .day.disabled {
            cursor: not-allowed;
            background-color: var(--border-color);
            color: #9ca3af;
        }
        .day span { display: block; }
        .day span:first-child { font-size: 0.8rem; font-weight: 500; }
        .day span:last-child { font-size: 1.25rem; font-weight: 600; }

        .time-slots {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(8rem, 1fr));
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .time-slot {
            padding: 1rem;
            text-align: center;
            border-radius: 1rem;
            cursor: pointer;
            border: 1px solid var(--border-color);
            transition: all var(--transition-speed);
            font-weight: 500;
            position: relative; /* Add for absolute positioning of counts */
        }
        
        .time-slot.selected {
            background-color: var(--primary-color);
            color: var(--card-bg);
            border-color: var(--primary-color);
        }
        
        .time-slot.full {
            background-color: #fecaca;
            color: #b91c1c;
            border-color: #fca5a5;
            cursor: not-allowed;
        }
        
        .slot-count {
            font-size: 0.75rem;
            color: var(--sub-text-color);
            margin-top: 0.25rem;
        }
        .time-slot.full .slot-count {
            color: #b91c1c;
        }
        
        .instructions-section {
            margin-top: 2rem;
        }
        .instructions-section textarea {
            width: 100%;
            height: 8rem;
            padding: 1rem;
            border: 1px solid var(--border-color);
            border-radius: 1rem;
            resize: vertical;
            font-family: 'Montserrat', sans-serif;
            font-size: 1rem;
            background-color: var(--bg-color);
        }

        /* Step 4: Worker Selection */
        .workers-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(10rem, 1fr));
            gap: 1.5rem;
            margin-top: 1.5rem;
        }
        
        .worker-card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 1.5rem;
            padding: 1.5rem;
            text-align: center;
            cursor: pointer;
            transition: all var(--transition-speed);
        }
        .worker-card:hover {
            box-shadow: 0 10px 20px -5px var(--shadow-light);
            transform: translateY(-0.25rem);
        }
        .worker-card.selected {
            border-color: var(--primary-color);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
        }

        .worker-avatar {
            width: 5rem;
            height: 5rem;
            border-radius: 50%;
            background-color: var(--bg-color);
            margin: 0 auto 1rem;
            background-size: cover;
            background-position: center;
            border: 3px solid var(--primary-color);
        }

        .worker-name {
            font-weight: 600;
            font-size: 1rem;
        }

        .worker-rating {
            color: #facc15;
            font-size: 1.1rem;
            margin-top: 0.25rem;
        }
        
        /* Step 5: Contact Details */
        .form-group {
            margin-bottom: 1.25rem;
        }

        .form-group label {
            display: block;
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .form-group input, .form-group textarea {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid var(--border-color);
            border-radius: 0.75rem;
            font-size: 1rem;
            background-color: var(--bg-color);
        }
        
        .form-group input:focus, .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.25);
        }

        .input-row {
            display: flex;
            gap: 1rem;
        }
        .input-row .form-group {
            flex: 1;
        }

        /* Step 6: Payment Styles */
        .payment-options {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            margin-top: 1.5rem;
        }

        .payment-option {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            border-radius: 1.5rem;
            padding: 1.5rem;
            display: flex;
            align-items: center;
            cursor: pointer;
            transition: all var(--transition-speed);
        }

        .payment-option.selected {
            border-color: var(--primary-color);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.2);
        }

        .payment-option input[type="radio"] {
            margin-right: 1rem;
            accent-color: var(--primary-color);
            width: 1.25rem;
            height: 1.25rem;
        }
        
        .payment-option label {
            font-weight: 600;
        }

        .payment-logos {
            margin-left: auto;
            display: flex;
            gap: 0.5rem;
        }

        .payment-logos img {
            height: 1.5rem;
        }
        
        .online-payment-form {
            background-color: var(--primary-light);
            border-radius: 1rem;
            padding: 2rem;
            margin-top: 1.5rem;
            border: 1px solid var(--primary-color);
            display: none;
        }
        
        .online-payment-form.active {
            display: block;
        }

        .form-actions {
            position: absolute;
            bottom: 2.5rem;
            right: 2.5rem;
            display: flex;
            gap: 1rem;
        }

        .next-step-btn {
            padding: 1rem 2rem;
            background-color: var(--primary-color);
            color: var(--card-bg);
            border: none;
            border-radius: 2rem;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all var(--transition-speed);
        }

        .mobile-total span:first-child {
            font-size: 0.8rem;
            color: var(--sub-text-color);
        }

        .mobile-total span:last-child {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--primary-color);
        }

        .next-step-btn:hover {
            background-color: #1d4ed8;
            transform: translateY(-0.125rem);
        }

        .booking-summary {
            flex: 1;
            background-color: #f9fafb;
            border-left: 1px solid var(--border-color);
            padding: 2.5rem;
            display: flex;
            flex-direction: column;
            overflow-y: auto;
            height: 100%;
        }
        
        .booking-summary::-webkit-scrollbar {
            width: 8px;
        }
        
        .booking-summary::-webkit-scrollbar-thumb {
            background-color: #d1d5db;
            border-radius: 4px;
        }

        .summary-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--text-color);
            padding-bottom: 1.5rem;
            margin-bottom: 1.5rem;
            position: relative;
        }
        .summary-title::after {
            content: '';
            position: absolute;
            left: 0;
            bottom: 0;
            width: 3rem;
            height: 3px;
            background-color: var(--primary-color);
        }

        .summary-section {
            margin-bottom: 2rem;
        }

        .summary-section h4 {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--text-color);
            margin-bottom: 1rem;
        }
        
        .summary-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.95rem;
            padding: 0.75rem 0;
            border-bottom: 1px dashed var(--border-color);
        }

        .summary-item:last-child {
            border-bottom: none;
        }

        .summary-item-name {
            font-weight: 500;
            color: var(--text-color);
        }

        .summary-item-price {
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .summary-info-block {
            padding: 0.75rem 0;
        }
        .summary-info-block p {
            margin: 0;
            padding: 0;
            font-size: 0.95rem;
            color: var(--sub-text-color);
        }
        .summary-info-block p span {
            font-weight: 600;
            color: var(--text-color);
        }

        .remove-btn {
            background-color: transparent;
            color: #ef4444;
            border: none;
            font-size: 1.25rem;
            cursor: pointer;
            padding: 0 0.5rem;
            transition: color 0.2s;
        }
        
        .remove-btn:hover {
            color: #dc2626;
        }

        .summary-total {
            margin-top: auto;
            padding-top: 2rem;
            border-top: 2px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-color);
        }

        .empty-summary {
            text-align: center;
            color: var(--sub-text-color);
            font-style: italic;
            padding: 1.5rem 0;
            font-size: 0.9rem;
        }
        
        @media (max-width: 1024px) {
            .main-container {
                flex-direction: column;
                height: auto;
                min-height: 100vh;
                border-radius: 1.5rem;
                overflow: visible !important;
            }

            .main-content {
                width: 100%;
                flex: none;
                padding: 1.5rem;
                padding-bottom: 8rem;
                overflow: visible !important;
            }

            .booking-summary {
                width: 100%;
                border-left: none;
                border-top: 1px solid var(--border-color);
                padding: 1.5rem;
                flex: none;
                height: auto;
                display: none;
            }

            .main-container.on-last-step .booking-summary {
                display: flex; /* Show summary on the last step */
            }

            .form-steps {
                overflow: visible !important;
            }

            .form-step {
                display: none;
                position: static;
                height: auto;
                opacity: 1 !important;
                transform: none !important;
                overflow: visible !important;
                padding-right: 0;
            }
            .form-step.active {
                display: flex;
            }

            .form-actions {
                position: fixed;
                bottom: 0;
                left: 0;
                right: 0;
                padding: 1rem 1.5rem;
                background-color: var(--card-bg);
                border-top: 1px solid var(--border-color);
                box-shadow: 0 -2px 10px var(--shadow-light);
                z-index: 10;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            .mobile-total {
                display: flex;
                flex-direction: column;
                justify-content: center;
            }
            .form-actions .next-step-btn {
                /* width: 100%; */ /* Let the button size itself */
            }
        }

        @media (max-width: 768px) {
            body {
                padding: 0;
            }
            .main-container {
                border-radius: 0;
                height: auto;
                min-height: 100vh;
            }
            .main-content, .booking-summary {
                padding: 1.5rem 1rem;
            }
            .main-content {
                padding-bottom: 7rem; /* space for button */
            }
            .form-header {
                gap: 1rem;
                margin-bottom: 1.5rem;
            }
            .back-btn {
                font-size: 1.5rem;
            }
            .step-info h1 {
                font-size: 1.25rem;
            }
            .step-content-heading {
                font-size: 1.1rem;
            }
            .step-content-subtitle {
                font-size: 0.9rem;
                margin-bottom: 1.5rem;
            }
            .service-card, .addon-card, .payment-option {
                padding: 1rem;
                border-radius: 1rem;
            }
            .input-row {
                flex-direction: column;
                gap: 0;
            }
            .category-tab {
                padding: 0.5rem 1.25rem;
            }
            .calendar {
                display: flex;
                overflow-x: auto;
                padding-bottom: 1rem;
                -webkit-overflow-scrolling: touch;
                scrollbar-width: none;
            }
            .calendar::-webkit-scrollbar {
                display: none;
            }
            .day {
                flex: 0 0 4.5rem;
            }
            .categories {
                top: 0;
                width: 100vw;
                margin-left: -1rem;
                padding-left: 1rem;
                padding-right: 1rem;
            }
            .summary-title {
                font-size: 1.25rem;
                padding-bottom: 1rem;
                margin-bottom: 1rem;
            }
            .summary-section h4 {
                font-size: 1rem;
            }
            .summary-item, .summary-info-block p {
                font-size: 0.9rem;
            }
            .summary-total {
                font-size: 1.25rem;
                padding-top: 1.5rem;
            }
        }
    </style>
</head>
<body>

    <div class="main-container">
        <div class="main-content">
            <div class="form-header">
                <button id="back-step-btn" class="back-btn" style="display:none;"><i class="fas fa-arrow-left"></i></button>
                <div class="step-info">
                    <h1 id="step-title">Service Selection</h1>
                    <div class="progress-bar-container">
                        <div class="progress-bar-fill"></div>
                    </div>
                </div>
            </div>

            <div class="form-steps">

                <div class="form-step active" id="step-1">
                    <h2 class="step-content-heading">Choose Your Service</h2>
<div class="categories">
    <div class="category-tab active" data-category="general">GENERAL</div>
    <div class="category-tab" data-category="cockroaches">Cockroaches</div>
    <div class="category-tab" data-category="ants">Ants</div>
    <div class="category-tab" data-category="bed-bugs">Bed Bugs</div>
    <div class="category-tab" data-category="rodents">Rodents</div>
    <div class="category-tab" data-category="flies-mosquitos">Flies & Mosquitos</div>
    <div class="category-tab" data-category="termite-control">Termite Control</div>
    <div class="category-tab" data-category="fleas-control">Fleas Control</div>
    <div class="category-tab" data-category="mold-control">Mold Control</div>
    <div class="category-tab" data-category="silverfishes-control">Silverfishes Control</div>
    <div class="category-tab" data-category="dust-mites">Dust Mites</div>
    <div class="category-tab" data-category="wasp-control">Wasp Control</div>
    <div class="category-tab" data-category="spider-control">Spider Control</div>
    <div class="category-tab" data-category="beehive-removal">Beehive Removal</div>
    <div class="category-tab" data-category="general-insects-removal">General Insects Removal</div>
</div>
    <div class="service-category" id="general">
        <h3>GENERAL</h3>
        <div class="service-card" data-service-id="general-studio" data-name="STUDIO" data-price="129">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">General Pest Control for Studio.</span>
                <span class="service-price">AED 129</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-1bhk" data-name="1 BHK" data-price="149">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">General Pest Control for 1 BHK.</span>
                <span class="service-price">AED 149</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-2bhk" data-name="2 BHK" data-price="169">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">General Pest Control for 2 BHK.</span>
                <span class="service-price">AED 169</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-3bhk" data-name="3 BHK" data-price="189">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">General Pest Control for 3 BHK.</span>
                <span class="service-price">AED 189</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-4bhk" data-name="4 BHK" data-price="209">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">General Pest Control for 4 BHK.</span>
                <span class="service-price">AED 209</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-5bhk" data-name="5 BHK" data-price="229">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">General Pest Control for 5 BHK.</span>
                <span class="service-price">AED 229</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-2bed-villa" data-name="2 BED VILLA" data-price="249">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">General Pest Control for 2 Bed Villa.</span>
                <span class="service-price">AED 249</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-3bed-villa" data-name="3 BED VILLA" data-price="289">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">General Pest Control for 3 Bed Villa.</span>
                <span class="service-price">AED 289</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-4bed-villa" data-name="4 BED VILLA" data-price="329">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">General Pest Control for 4 Bed Villa.</span>
                <span class="service-price">AED 329</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-5bed-villa" data-name="5 BED VILLA" data-price="369">
            <div class="service-info">
                <span class="service-name">5 BED VILLA</span>
                <span class="service-description">General Pest Control for 5 Bed Villa.</span>
                <span class="service-price">AED 369</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="cockroaches">
        <h3>Cockroaches</h3>
        <div class="service-card" data-service-id="cockroaches-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Cockroaches Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Cockroaches Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Cockroaches Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Cockroaches Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Cockroaches Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Cockroaches Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">Cockroaches Treatment for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">Cockroaches Treatment for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">Cockroaches Treatment for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="cockroaches-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BED VILLA</span>
                <span class="service-description">Cockroaches Treatment for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="ants">
        <h3>Ants</h3>
        <div class="service-card" data-service-id="ants-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Ants Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Ants Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Ants Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Ants Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Ants Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Ants Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">Ants Treatment for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">Ants Treatment for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">Ants Treatment for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="ants-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BED VILLA</span>
                <span class="service-description">Ants Treatment for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="bed-bugs">
        <h3>Bed Bugs</h3>
        <div class="service-card" data-service-id="bed-bugs-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-2bhk" data-name="2 BHK " data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="bed-bugs-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BED VILLA ( Family Residence)</span>
                <span class="service-description">Bed Bugs Treatment for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="rodents">
        <h3>Rodents</h3>
        <div class="service-card" data-service-id="rodents-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Rodents Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Rodents Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Rodents Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Rodents Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Rodents Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Rodents Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">Rodents Treatment for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">Rodents Treatment for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">Rodents Treatment for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="rodents-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BED VILLA</span>
                <span class="service-description">Rodents Treatment for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="flies-mosquitos">
        <h3>Flies & Mosquitos</h3>
        <div class="service-card" data-service-id="flies-mosquitos-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Flies & Mosquitos Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Flies & Mosquitos Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Flies & Mosquitos Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Flies & Mosquitos Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Flies & Mosquitos Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Flies & Mosquitos Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">Flies & Mosquitos Treatment for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">Flies & Mosquitos Treatment for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">Flies & Mosquitos Treatment for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="flies-mosquitos-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BED VILLA</span>
                <span class="service-description">Flies & Mosquitos Treatment for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="termite-control">
        <h3>Termite Control</h3>
        <div class="service-card" data-service-id="termite-control-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Termite Control for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Termite Control for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Termite Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Termite Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Termite Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Termite Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-2bed-villa" data-name="2 BED VILLA" data-price="219">
            <div class="service-info">
                <span class="service-name">2 BED VILLA</span>
                <span class="service-description">Termite Control for 2 Bed Villa.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-3bed-villa" data-name="3 BED VILLA" data-price="239">
            <div class="service-info">
                <span class="service-name">3 BED VILLA</span>
                <span class="service-description">Termite Control for 3 Bed Villa.</span>
                <span class="service-price">AED 239</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-4bed-villa" data-name="4 BED VILLA" data-price="259">
            <div class="service-info">
                <span class="service-name">4 BED VILLA</span>
                <span class="service-description">Termite Control for 4 Bed Villa.</span>
                <span class="service-price">AED 259</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="termite-control-5bed-villa" data-name="5 BED VILLA" data-price="279">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Termite Control for 5 Bed Villa.</span>
                <span class="service-price">AED 279</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="fleas-control">
        <h3>Fleas Control</h3>
        <div class="service-card" data-service-id="fleas-control-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Fleas Control for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="fleas-control-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Fleas Control for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="fleas-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Fleas Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="fleas-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Fleas Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="fleas-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Fleas Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="fleas-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Fleas Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="mold-control">
        <h3>Mold Control</h3>
        <div class="service-card" data-service-id="mold-control-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Mold Control for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="mold-control-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Mold Control for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="mold-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Mold Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="mold-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Mold Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="mold-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Mold Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="mold-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Mold Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="silverfishes-control">
        <h3>Silverfishes Control</h3>
        <div class="service-card" data-service-id="silverfishes-control-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Silverfishes Control for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="silverfishes-control-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Silverfishes Control for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="silverfishes-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Silverfishes Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="silverfishes-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Silverfishes Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="silverfishes-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Silverfishes Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="silverfishes-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Silverfishes Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="dust-mites">
        <h3>Dust Mites</h3>
        <div class="service-card" data-service-id="dust-mites-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Dust Mites Treatment for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="dust-mites-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Dust Mites Treatment for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="dust-mites-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Dust Mites Treatment for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="dust-mites-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Dust Mites Treatment for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="dust-mites-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Dust Mites Treatment for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="dust-mites-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Dust Mites Treatment for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="wasp-control">
        <h3>Wasp Control</h3>
        <div class="service-card" data-service-id="wasp-control-studio" data-name="STUDIO" data-price="249">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Wasp Control for Studio.</span>
                <span class="service-price">AED 249</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="wasp-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Wasp Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="wasp-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Wasp Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="wasp-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Wasp Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="wasp-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Wasp Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="spider-control">
        <h3>Spider Control</h3>
        <div class="service-card" data-service-id="spider-control-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Spider Control for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="spider-control-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">Spider Control for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="spider-control-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">Spider Control for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="spider-control-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">Spider Control for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="spider-control-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">Spider Control for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="spider-control-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">Spider Control for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="beehive-removal">
        <h3>Beehive Removal</h3>
        <div class="service-card" data-service-id="beehive-removal-studio" data-name="STUDIO" data-price="249">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">Beehive Removal for Studio.</span>
                <span class="service-price">AED 249</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
    
    <div class="service-category" id="general-insects-removal">
        <h3>General Insects Removal</h3>
        <div class="service-card" data-service-id="general-insects-removal-studio" data-name="STUDIO" data-price="119">
            <div class="service-info">
                <span class="service-name">STUDIO</span>
                <span class="service-description">General Insects Removal for Studio.</span>
                <span class="service-price">AED 119</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-insects-removal-1bhk" data-name="1 BHK" data-price="139">
            <div class="service-info">
                <span class="service-name">1 BHK</span>
                <span class="service-description">General Insects Removal for 1 BHK.</span>
                <span class="service-price">AED 139</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-insects-removal-2bhk" data-name="2 BHK" data-price="159">
            <div class="service-info">
                <span class="service-name">2 BHK</span>
                <span class="service-description">General Insects Removal for 2 BHK.</span>
                <span class="service-price">AED 159</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-insects-removal-3bhk" data-name="3 BHK" data-price="179">
            <div class="service-info">
                <span class="service-name">3 BHK</span>
                <span class="service-description">General Insects Removal for 3 BHK.</span>
                <span class="service-price">AED 179</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-insects-removal-4bhk" data-name="4 BHK" data-price="199">
            <div class="service-info">
                <span class="service-name">4 BHK</span>
                <span class="service-description">General Insects Removal for 4 BHK.</span>
                <span class="service-price">AED 199</span>
            </div>
            <button class="add-button">+</button>
        </div>
        <div class="service-card" data-service-id="general-insects-removal-5bhk" data-name="5 BHK" data-price="219">
            <div class="service-info">
                <span class="service-name">5 BHK</span>
                <span class="service-description">General Insects Removal for 5 BHK.</span>
                <span class="service-price">AED 219</span>
            </div>
            <button class="add-button">+</button>
        </div>
    </div>
                </div>

                <div class="form-step" id="step-2">
                    <h2 class="step-content-heading">Add-on Services</h2>
                    <p class="step-content-subtitle">Add extra services for a complete solution.</p>
                    <div class="addon-card" data-service-id="addon1" data-name="Odor Removal" data-price="100">
                        <div class="addon-info">
                            <span class="addon-name">Odor Removal Treatment</span>
                            <span class="addon-price">AED 100</span>
                        </div>
                        <input type="checkbox">
                    </div>
                    <div class="addon-card" data-service-id="addon2" data-name="Deep Crawling Insect Treatment" data-price="150">
                        <div class="addon-info">
                            <span class="addon-name">Deep Crawling Insect Treatment</span>
                            <span class="addon-price">AED 150</span>
                        </div>
                        <input type="checkbox">
                    </div>
                    <div class="addon-card" data-service-id="addon3" data-name="Outdoor Perimeter Spray" data-price="80">
                        <div class="addon-info">
                            <span class="addon-name">Outdoor Perimeter Spray</span>
                            <span class="addon-price">AED 80</span>
                        </div>
                        <input type="checkbox">
                    </div>
                </div>

                <div class="form-step" id="step-3">
                    <h2 class="step-content-heading">Select Date & Time</h2>
                    <p class="step-content-subtitle">Choose a convenient date and time for the service.</p>
                    
                    <h3>Select Date</h3>
                    <div class="calendar" id="calendar"></div>
                    
                    <h3>Select Time Slot</h3>
                    <div class="time-slots" id="time-slots">
                        <p class="empty-summary">Please select a date first.</p>
                    </div>

                    <div class="instructions-section">
                        <h3>Any instructions or special requests?</h3>
                        <textarea id="special-instructions" placeholder="e.g. Please call me before arrival, or enter through the side gate."></textarea>
                    </div>
                </div>

                <div class="form-step" id="step-4">
                    <h2 class="step-content-heading">Choose Your Worker</h2>
                    <p class="step-content-subtitle">Select a professional for your service based on their rating.</p>
                    <div class="workers-grid">
                        <div class="worker-card" data-worker-id="worker1" data-name="Ameer Hamza">
                            <div class="worker-avatar" style="background-image: url('https://prudentpestservices.com/wp-content/uploads/2025/08/team1.jpg');"></div>
                            <div class="worker-name"> Ameer Hamza</div>
                            <div class="worker-rating">★★★★★</div>
                        </div>
                        <div class="worker-card" data-worker-id="worker2" data-name="MIRZA AMIN">
                            <div class="worker-avatar" style="background-image: url('https://prudentpestservices.com/wp-content/uploads/2025/08/team2.jpg');"></div>
                            <div class="worker-name">MIRZA AMIN</div>
                            <div class="worker-rating">★★★★★</div>
                        </div>
                        <div class="worker-card" data-worker-id="worker3" data-name="Zameer Ul Hassan">
                            <div class="worker-avatar" style="background-image: url('https://prudentpestservices.com/wp-content/uploads/2025/08/team3.jpg');"></div>
                            <div class="worker-name">Zameer Ul Hassan</div>
                            <div class="worker-rating">★★★★★</div>
                        </div>
                    </div>
                </div>

                <div class="form-step" id="step-5">
                    <h2 class="step-content-heading">Your Contact Details</h2>
                    <p class="step-content-subtitle">Please provide your details for booking confirmation.</p>
                    <div class="form-group">
                        <label for="full-name">Full Name</label>
                        <input type="text" id="full-name" placeholder="Enter your full name">
                    </div>
                    <div class="form-group">
                        <label for="address">Address</label>
                        <textarea id="address" placeholder="Enter your full address"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" placeholder="Enter your email">
                    </div>
                    <div class="form-group">
                        <label for="phone-number">Phone Number</label>
                        <input type="tel" id="phone-number" placeholder="Enter your phone number">
                    </div>
                    <div class="form-group">
                        <label for="location-link">Paste your location link here (optional)</label>
                        <input type="url" id="location-link" name="locationLink" placeholder="Google Maps or other location link">
                    </div>
                </div>

                <div class="form-step" id="step-6">
                    <h2 class="step-content-heading">Select Payment Method</h2>
                    <p class="step-content-subtitle">Choose how you would like to pay for the service.</p>
                    <div class="payment-options">
                        <label class="payment-option" for="stripe-payment">
                            <input type="radio" id="stripe-payment" name="payment-method" value="Online Payment (Stripe)">
                            <span>Pay Online via Card</span>
                            <div class="payment-logos">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Visa_Inc._logo.svg/1280px-Visa_Inc._logo.svg.png" alt="Visa">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/b/b7/MasterCard_Logo.svg/1280px-MasterCard_Logo.svg.png" alt="Mastercard">
                            </div>
                        </label>
                        <label class="payment-option" for="cash-payment">
                            <input type="radio" id="cash-payment" name="payment-method" value="Cash on Service" checked>
                            <span>Pay with Cash on Service</span>
                        </label>
                    </div>
                    
                    <div class="online-payment-form" id="online-payment-form">
                        <p class="discount-note">A 5% discount will be applied for paying online!</p>
                        <div id="card-element" class="form-group"></div>
                    </div>
                </div>
            </div>
            
            <div class="form-actions">
                <div class="mobile-total">
                    <span>Total</span>
                    <span id="mobile-total-price">AED 0</span>
                </div>
                <button class="next-step-btn" id="next-step-btn">Next Step</button>
            </div>
        </div>

        <div class="booking-summary">
            <h3 class="summary-title">Booking Summary</h3>
            
            <div class="summary-section">
                <h4>Your Services</h4>
                <div id="summary-items">
                    <div class="empty-summary">No services selected.</div>
                </div>
            </div>

            <div class="summary-section">
                <h4>Booking Details</h4>
                <div id="booking-details" class="summary-item">
                    <span id="booking-info" class="summary-item-name">Please select date and time.</span>
                </div>
            </div>

            <div class="summary-section">
                <h4>Selected Worker</h4>
                <div id="worker-details" class="summary-item">
                    <span id="worker-info" class="summary-item-name">Please select a worker.</span>
                </div>
            </div>
            
            <div class="summary-section">
                <h4>Contact Info</h4>
                <div id="contact-details" class="summary-info-block">
                    <p id="contact-name">Name: <span>-</span></p>
                    <p id="contact-address">Address: <span>-</span></p>
                    <p id="contact-email">Email: <span>-</span></p>
                    <p id="contact-phone">Phone: <span>-</span></p>
                    <p id="contact-location-link">Location Link: <span>-</span></p> <!-- Add this line -->
                </div>
            </div>

            <div class="summary-section">
                <h4>Payment Method</h4>
                <div id="payment-details" class="summary-item">
                    <span id="payment-info" class="summary-item-name">Please select a payment method.</span>
                </div>
            </div>
            
            <div class="summary-total">
                <span>Total</span>
                <span id="total-price">AED 0</span>
            </div>
        </div>
    </div>

    <script>
document.addEventListener('DOMContentLoaded', () => {
    const categoryTabs = document.querySelectorAll('.category-tab');
    const serviceCategories = document.querySelectorAll('.service-category');
    const formSteps = document.querySelectorAll('.form-step');
    const nextStepBtn = document.getElementById('next-step-btn');
    const backStepBtn = document.getElementById('back-step-btn');
    const progressBarFill = document.querySelector('.progress-bar-fill');
    const stepTitle = document.getElementById('step-title');
    const mainContainer = document.querySelector('.main-container');
    const mobileTotalPriceElement = document.getElementById('mobile-total-price');
    const summaryItemsContainer = document.getElementById('summary-items');
    const totalPriceElement = document.getElementById('total-price');
    const bookingInfoSpan = document.getElementById('booking-info');
    const workerInfoSpan = document.getElementById('worker-info');
    const paymentInfoSpan = document.getElementById('payment-info');
    const onlinePaymentForm = document.getElementById('online-payment-form');
    const contactNameSpan = document.getElementById('contact-name').querySelector('span');
    const contactAddressSpan = document.getElementById('contact-address').querySelector('span');
    const contactEmailSpan = document.getElementById('contact-email').querySelector('span');
    const contactPhoneSpan = document.getElementById('contact-phone').querySelector('span');
    const contactLocationLinkSpan = document.getElementById('contact-location-link').querySelector('span');
    const onlinePaymentRadio = document.getElementById('stripe-payment');

    let currentStep = 0;
    const stepTitles = ["Service Selection", "Add-on Services", "Appointment Details", "Choose Your Worker", "Contact Details", "Payment Method"];
    const selectedServices = {};
    const selectedAddons = {};
    let selectedDate = null;
    let selectedTime = null;
    let selectedWorker = null;
    let bookedWorkerIDsForSelectedSlot = [];
    let selectedPaymentMethod = 'Cash on Service'; // Default to cash
    const contactDetails = {};

    let bookedSlots = {}; // Initialize as empty. Will be filled by an AJAX call.

    const dubaiTodayString = '<?php echo date('Y-m-d'); ?>';
    const maxBookingsPerSlot = 3; // Set the maximum number of bookings per slot
    const onlinePaymentDiscountPercentage = 0.05; // 5%

    // --- Stripe Setup ---
    const stripe = Stripe('pk_live_51S3HwKJAtSKtnqSmwgc9FHImGpxk9NgJhXTmNzmuLuQ4MlEJaDAx1oD0bd50FuHkIvAgcM0wARYaHyxUpxj4rICj00Wj55wGKb'); // <-- IMPORTANT: REPLACE WITH YOUR STRIPE PUBLISHABLE KEY
    const elements = stripe.elements();
    const cardElement = elements.create('card');
    
    // --- New function to load data via AJAX to bypass caching ---
    const loadInitialData = async () => {
        try {
            // Add a cache-busting parameter (the timestamp) to the URL
            const response = await fetch(`?action=get_slots&t=${new Date().getTime()}`);
            if (!response.ok) {
                throw new Error(`Network response was not ok: ${response.statusText}`);
            }
            try {
                bookedSlots = await response.json();
            } catch (e) {
                console.error("FAILED TO PARSE BOOKING DATA:", e);
                bookedSlots = {}; // Prevent further errors
            }

            // Now that we have the fresh data, initialize the UI components that depend on it
            generateCalendar();
            handleInitialServiceSelection();
        } catch (error) {
            console.error("Failed to load booking availability:", error);
            alert("Error loading booking data. Please refresh the page to try again.");
        }
    };

    // --- Function to handle pre-selection of service from URL ---
    const handleInitialServiceSelection = () => {
        const urlParams = new URLSearchParams(window.location.search);
        const serviceFromUrl = urlParams.get('service');

        if (serviceFromUrl) {
            const targetTab = document.querySelector(`.category-tab[data-category="${serviceFromUrl}"]`);
            const targetCategorySection = document.getElementById(serviceFromUrl);

            if (targetTab && targetCategorySection) {
                // De-activate the default active tab
                const currentActiveTab = document.querySelector('.category-tab.active');
                if (currentActiveTab) {
                    currentActiveTab.classList.remove('active');
                }
                
                // Activate the target tab
                targetTab.classList.add('active');

                // Scroll to the target section after a brief delay to ensure layout is ready
                setTimeout(() => {
                    targetCategorySection.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }, 100);
            }
        }
    };

    const calculateTotal = () => {
        let total = 0;
        Object.values(selectedServices).forEach(service => total += service.price);
        Object.values(selectedAddons).forEach(addon => total += addon.price);

        // Apply discount if online payment is selected
        if (selectedPaymentMethod === 'Online Payment (Stripe)') {
            total *= (1 - onlinePaymentDiscountPercentage);
        }

        return total < 0 ? 0 : total;
    };

    const updateSummary = () => {
        let summaryHTML = '';

        Object.values(selectedServices).forEach(service => {
            const displayName = service.category ? `${service.category} - ${service.name}` : service.name;
            summaryHTML += `
                <div class="summary-item" data-service-id="${service.id}" data-type="service">
                    <span class="summary-item-name">${displayName}</span>
                    <span class="summary-item-price">AED ${service.price}</span>
                    <button class="remove-btn" data-service-id="${service.id}" data-type="service">&times;</button>
                </div>
            `;
        });

        Object.values(selectedAddons).forEach(addon => {
            summaryHTML += `
                <div class="summary-item" data-service-id="${addon.id}" data-type="addon">
                    <span class="summary-item-name">${addon.name} (Add-on)</span>
                    <span class="summary-item-price">AED ${addon.price}</span>
                    <button class="remove-btn" data-service-id="${addon.id}" data-type="addon">&times;</button>
                </div>
            `;
        });

        if (Object.keys(selectedServices).length === 0 && Object.keys(selectedAddons).length === 0) {
            summaryHTML = '<div class="empty-summary">No services selected.</div>';
        }

        // Add discount line if applicable
        if (selectedPaymentMethod === 'Online Payment (Stripe)' && (Object.keys(selectedServices).length > 0 || Object.keys(selectedAddons).length > 0)) {
            let originalTotal = 0;
            Object.values(selectedServices).forEach(service => originalTotal += service.price);
            Object.values(selectedAddons).forEach(addon => originalTotal += addon.price);
            const discountAmount = originalTotal * onlinePaymentDiscountPercentage;
             summaryHTML += `
                <div class="summary-item">
                    <span class="summary-item-name" style="color: #16a34a;">Online Payment Discount (5%)</span>
                    <span class="summary-item-price" style="color: #16a34a;">- AED ${discountAmount.toFixed(2)}</span>
                </div>
            `;
        }

        summaryItemsContainer.innerHTML = summaryHTML;
        const total = calculateTotal();
        totalPriceElement.textContent = `AED ${total.toFixed(2)}`;
        if (mobileTotalPriceElement) {
            mobileTotalPriceElement.textContent = `AED ${total.toFixed(2)}`;
        }
    };
    
    const updateBookingDetails = () => {
        if (selectedDate && selectedTime) {
            const dateObj = new Date(selectedDate + 'T00:00:00'); // Ensure timezone is handled correctly
            const options = { weekday: 'short', year: 'numeric', month: 'short', day: 'numeric' };
            const formattedDate = dateObj.toLocaleDateString('en-US', options);
            bookingInfoSpan.textContent = `${formattedDate}, ${selectedTime}`;
        } else {
            bookingInfoSpan.textContent = 'Please select a date and time.';
        }
    };

    const updateWorkerDetails = () => {
        if (selectedWorker) {
            workerInfoSpan.textContent = selectedWorker.name;
        } else {
            workerInfoSpan.textContent = 'Please select a worker.';
        }
    };
    
    const updateContactDetails = () => {
        contactNameSpan.textContent = contactDetails.name || '-';
        contactAddressSpan.textContent = contactDetails.address || '-';
        contactEmailSpan.textContent = contactDetails.email || '-';
        contactPhoneSpan.textContent = contactDetails.phone || '-';
        contactLocationLinkSpan.textContent = contactDetails.locationLink || '-';
    };
    
    const updatePaymentDetails = () => {
        if (selectedPaymentMethod) {
            paymentInfoSpan.textContent = selectedPaymentMethod;
        } else {
            paymentInfoSpan.textContent = 'Please select a payment method.';
        }
    };

    const updateWorkerView = () => {
        const workerCards = document.querySelectorAll('.worker-card');
        const workersGrid = document.querySelector('.workers-grid');
        let availableWorkersCount = 0;

        workerCards.forEach(card => {
            const workerId = card.dataset.workerId;
            const isBooked = bookedWorkerIDsForSelectedSlot.includes(workerId);

            // Check if the worker's ID is in the list of booked IDs for the selected slot
            if (isBooked) {
                card.style.display = 'none'; // Hide booked worker

                // If this hidden worker was the one selected, unselect them
                if (selectedWorker && selectedWorker.id === workerId) {
                    selectedWorker = null;
                    card.classList.remove('selected');
                    updateWorkerDetails();
                }
            } else {
                card.style.display = 'block'; // Ensure available worker is visible
                availableWorkersCount++;
            }
        });

        // Display a message if no workers are available for the selected slot
        let noWorkersMessage = document.getElementById('no-workers-message');
        if (availableWorkersCount === 0) {
            if (!noWorkersMessage) {
                noWorkersMessage = document.createElement('p');
                noWorkersMessage.id = 'no-workers-message';
                noWorkersMessage.className = 'empty-summary';
                noWorkersMessage.style.textAlign = 'center';
                noWorkersMessage.style.marginTop = '1rem';
                workersGrid.parentNode.insertBefore(noWorkersMessage, workersGrid.nextSibling);
            }
            noWorkersMessage.textContent = 'All professionals are booked for this time slot. Please select a different time or date.';
            noWorkersMessage.style.display = 'block';
        } else if (noWorkersMessage) {
            noWorkersMessage.style.display = 'none';
        }
    };

    const showStep = (stepIndex) => {
        formSteps.forEach((step, index) => {
            step.classList.remove('active');
            if (index === stepIndex) {
                step.classList.add('active');
            }
        });
        progressBarFill.style.width = `${(stepIndex / (formSteps.length - 1)) * 100}%`;
        stepTitle.textContent = stepTitles[stepIndex];
        backStepBtn.style.display = (stepIndex === 0) ? 'none' : 'block';
        
        if (stepIndex === formSteps.length - 1) {
            nextStepBtn.textContent = 'Finalize Booking';
        } else {
            nextStepBtn.textContent = 'Next Step';
        }

        // When moving to "Choose Worker" step, update the view based on selected time
        if (stepIndex === 3) { 
            updateWorkerView();
        }

        // For mobile: Add/remove class to show summary only on the last step
        if (window.matchMedia("(max-width: 1024px)").matches) {
            if (stepIndex === formSteps.length - 1) {
                mainContainer.classList.add('on-last-step');
            } else {
                mainContainer.classList.remove('on-last-step');
            }
        }
    };
    
    showStep(currentStep);

    // Step 1: Main Services
    document.getElementById('step-1').addEventListener('click', (event) => {
        const button = event.target.closest('.add-button');
        if (button) {
            const card = button.closest('.service-card');
            const serviceId = card.dataset.serviceId;
            const serviceName = card.dataset.name;
            const servicePrice = parseInt(card.dataset.price);
            const categoryElement = card.closest('.service-category');
            const categoryName = categoryElement ? categoryElement.querySelector('h3').textContent : 'Service';
            
            if (!selectedServices[serviceId]) {
                selectedServices[serviceId] = { id: serviceId, name: serviceName, price: servicePrice, category: categoryName };
                updateSummary();
            }
        }
    });
    
    // Category Tab functionality
    categoryTabs.forEach(tab => {
        tab.addEventListener('click', () => {
            const categoryId = tab.dataset.category;
            const targetSection = document.getElementById(categoryId);
            if (targetSection) {
                targetSection.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Highlight category tab on scroll
    const scrollableElement = window.innerWidth <= 1024 ? window : document.getElementById('step-1');
    
    scrollableElement.addEventListener('scroll', () => {
        if (currentStep !== 0) return;

        let currentCategory = '';
        const stickyHeaderOffset = 85; // Height of the sticky bar + some buffer
        const scrollAreaTop = (scrollableElement === window) ? 0 : document.getElementById('step-1').getBoundingClientRect().top;

        serviceCategories.forEach(category => {
            if (category.getBoundingClientRect().top < scrollAreaTop + stickyHeaderOffset) {
                currentCategory = category.getAttribute('id');
            }
        });

        categoryTabs.forEach(tab => {
            tab.classList.remove('active');
            if (tab.dataset.category === currentCategory) {
                tab.classList.add('active');
                tab.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'center' });
            }
        });
    });

    // Step 2: Add-on Services
    document.getElementById('step-2').addEventListener('click', (event) => {
        const card = event.target.closest('.addon-card');
        if (card) {
            const addonId = card.dataset.serviceId;
            const addonName = card.dataset.name;
            const addonPrice = parseInt(card.dataset.price);
            const isSelected = !!selectedAddons[addonId];

            if (isSelected) {
                delete selectedAddons[addonId];
                card.classList.remove('selected');
                card.querySelector('input[type="checkbox"]').checked = false;
            } else {
                selectedAddons[addonId] = { id: addonId, name: addonName, price: addonPrice };
                card.classList.add('selected');
                card.querySelector('input[type="checkbox"]').checked = true;
            }
            updateSummary();
        }
    });

    // Step 3: Appointment Booking
    const calendar = document.getElementById('calendar');
    const timeSlotsContainer = document.getElementById('time-slots');
    
    const generateCalendar = () => {
        calendar.innerHTML = '';
        // Start from Dubai's current date, passed from PHP.
        // We add 'T00:00:00' to ensure it's parsed as local time midnight, avoiding timezone shifts.
        const today = new Date(dubaiTodayString + 'T00:00:00');
        
        for (let i = 0; i < 7; i++) {
            const date = new Date(today);
            date.setDate(today.getDate() + i);

            // Manually format the date to YYYY-MM-DD to avoid timezone issues with toISOString()
            const year = date.getFullYear();
            const month = String(date.getMonth() + 1).padStart(2, '0');
            const day = String(date.getDate()).padStart(2, '0');
            const dateString = `${year}-${month}-${day}`;

            const dayName = date.toLocaleDateString('en-US', { weekday: 'short' });
            const dayOfMonth = date.getDate();

            const dayDiv = document.createElement('div');
            dayDiv.classList.add('day');
            dayDiv.dataset.date = dateString;
            dayDiv.innerHTML = `<span>${dayName}</span><span>${dayOfMonth}</span>`;
            calendar.appendChild(dayDiv);
        }
    };

    const generateTimeSlots = (date) => {
        timeSlotsContainer.innerHTML = '';
const slots = [
  '08:00 AM',
  '09:30 AM',
  '11:00 AM',
  '12:30 PM',
  '02:00 PM',
  '03:30 PM',
  '05:00 PM',
  '06:30 PM'
];
        const formattedDate = date.dataset.date;
        const bookedCount = bookedSlots[formattedDate] || {};
        
        slots.forEach(time => {
            const slotData = bookedCount[time];
            const bookings = slotData ? slotData.count : 0;
            const remaining = maxBookingsPerSlot - bookings;
            const isFull = remaining <= 0;
            const slotText = isFull ? 'Fully Booked' : `${remaining} / ${maxBookingsPerSlot} slots available`;

            const timeDiv = document.createElement('div');
            timeDiv.classList.add('time-slot');
            timeDiv.dataset.time = time;
            
            timeDiv.innerHTML = `
                <div>${time}</div>
                <div class="slot-count">${slotText}</div>
            `;

            if (isFull) {
                timeDiv.classList.add('full');
            } else {
                timeDiv.addEventListener('click', () => {
                    document.querySelectorAll('.time-slot.selected').forEach(slot => slot.classList.remove('selected'));
                    timeDiv.classList.add('selected');
                    selectedDate = formattedDate;
                    selectedTime = time;

                    // Store the list of booked workers for this specific slot
                    const currentSlotData = bookedSlots[selectedDate]?.[selectedTime];
                    bookedWorkerIDsForSelectedSlot = currentSlotData ? currentSlotData.worker_ids : [];
                    updateBookingDetails();
                });
            }
            timeSlotsContainer.appendChild(timeDiv);
        });
    };

    calendar.addEventListener('click', (event) => {
        const day = event.target.closest('.day');
        if (day && !day.classList.contains('disabled')) {
            document.querySelectorAll('.day.selected').forEach(d => d.classList.remove('selected'));
            day.classList.add('selected');
            generateTimeSlots(day);
        }
    });

    // Step 4: Worker Selection
    document.getElementById('step-4').addEventListener('click', (event) => {
        const card = event.target.closest('.worker-card');
        if (card) {
            const workerId = card.dataset.workerId;
            const workerName = card.dataset.name;
            
            document.querySelectorAll('.worker-card.selected').forEach(c => c.classList.remove('selected'));
            card.classList.add('selected');

            selectedWorker = { id: workerId, name: workerName };
            updateWorkerDetails();
        }
    });
    
    // Step 5: Contact Details
    document.getElementById('step-5').addEventListener('input', (event) => {
        const field = event.target;
        if (field.id === 'full-name') contactDetails.name = field.value;
        if (field.id === 'address') contactDetails.address = field.value;
        if (field.id === 'email') contactDetails.email = field.value;
        if (field.id === 'phone-number') contactDetails.phone = field.value;
        if (field.id === 'location-link') contactDetails.locationLink = field.value; // Add this line
        updateContactDetails();
    });


    // Step 6: Payment Method
    document.getElementById('step-6').addEventListener('click', (event) => {
        const option = event.target.closest('.payment-option');
        if (option) {
            const radio = option.querySelector('input[type="radio"]');
            radio.checked = true;
            
            document.querySelectorAll('.payment-option.selected').forEach(opt => opt.classList.remove('selected'));
            option.classList.add('selected');
            
            selectedPaymentMethod = radio.value;
            updatePaymentDetails();
            updateSummary(); // Recalculates total with discount
            
            if (selectedPaymentMethod === "Online Payment (Stripe)") {
                onlinePaymentForm.classList.add('active');
                // Mount Stripe element only when it becomes visible
                cardElement.mount('#card-element');
            } else {
                onlinePaymentForm.classList.remove('active');
                cardElement.unmount();
            }
        }
    });

    const handleNextStep = async () => {
        if (currentStep === 0 && Object.keys(selectedServices).length === 0) {
            alert("Please select at least one main service to proceed.");
            return;
        } else if (currentStep === 2 && (!selectedDate || !selectedTime)) {
            alert("Please select a date and time to proceed.");
            return;
        } else if (currentStep === 3 && !selectedWorker) {
            alert("Please select a worker to proceed.");
            return;
        } else if (currentStep === 4) {
            if (!contactDetails.name || !contactDetails.address || !contactDetails.email || !contactDetails.phone) {
                alert("Please fill out all contact details to proceed.");
                return;
            }
        } else if (currentStep === 5) {
            if (!selectedPaymentMethod) {
                alert("Please select a payment method to proceed.");
                return;
            }
        }

        if (currentStep < formSteps.length - 1) {
            currentStep++;
            showStep(currentStep);
        } else {
            // --- FINAL SUBMISSION LOGIC ---
            const bookingData = {
                services: Object.values(selectedServices),
                addons: Object.values(selectedAddons),
                date: selectedDate,
                time: selectedTime,
                worker: selectedWorker,
                contactDetails: contactDetails,
                paymentMethod: selectedPaymentMethod,
                instructions: document.getElementById('special-instructions').value,
                totalPrice: calculateTotal() // This will be the discounted price if applicable
            };

            nextStepBtn.disabled = true;
            nextStepBtn.textContent = 'Processing...';

            if (selectedPaymentMethod === 'Online Payment (Stripe)') {
                // --- Stripe Payment Flow ---
                try {
                    // 1. Create Payment Intent on the server
                    const response = await fetch('?action=create-payment-intent', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ services: bookingData.services, addons: bookingData.addons })
                    });
                    const { clientSecret, error: intentError } = await response.json();

                    if (intentError) throw new Error(intentError);

                    // 2. Confirm the card payment on the client
                    const { paymentIntent, error: paymentError } = await stripe.confirmCardPayment(clientSecret, {
                        payment_method: { card: cardElement }
                    });

                    if (paymentError) {
                        throw new Error(paymentError.message);
                    }

                    // 3. If payment is successful, send all data to save the booking
                    if (paymentIntent.status === 'succeeded') {
                        bookingData.paymentIntentId = paymentIntent.id; // Add payment ID for server verification
                        saveBooking(bookingData);
                    } else {
                        throw new Error('Payment not successful. Status: ' + paymentIntent.status);
                    }
                } catch (error) {
                    console.error('Stripe Payment Error:', error);
                    alert('Payment failed: ' + error.message);
                    nextStepBtn.disabled = false;
                    nextStepBtn.textContent = 'Finalize Booking';
                }
            } else {
                // --- Cash Payment Flow ---
                saveBooking(bookingData);
            }
        }
    };

    const saveBooking = (bookingData) => {
        fetch('', { // Post to the same file to save
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(bookingData),
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.email_error || data.message); // Show email error or success message
                window.location.href = 'https://prudentpestservices.com/thank-you/';
            } else {
                alert('Booking failed! ' + data.message);
                console.error('Booking Error:', data.message);
                
                if (data.updatedSlots) {
                    bookedSlots = data.updatedSlots;
                    const selectedDayElement = document.querySelector('.day.selected');
                    if (selectedDayElement) {
                        generateTimeSlots(selectedDayElement);
                    }
                    const currentSlotData = bookedSlots[selectedDate]?.[selectedTime];
                    bookedWorkerIDsForSelectedSlot = currentSlotData ? (currentSlotData.worker_ids || []) : [];
                    updateWorkerView();
                }
            }
        })
        .catch((error) => {
            console.error('Save Booking Network Error:', error);
            alert('An error occurred while saving your booking. Please try again.');
        })
        .finally(() => {
            nextStepBtn.disabled = false;
            nextStepBtn.textContent = 'Finalize Booking';
        });
    };

    nextStepBtn.addEventListener('click', handleNextStep);

    backStepBtn.addEventListener('click', () => {
        if (currentStep > 0) {
            currentStep--;
            showStep(currentStep);
        }
    });

    document.querySelector('.booking-summary').addEventListener('click', (event) => {
        const button = event.target.closest('.remove-btn');
        if (button) {
            const serviceId = button.dataset.serviceId;
            const serviceType = button.dataset.type;

            if (serviceType === 'service') {
                delete selectedServices[serviceId];
            } else if (serviceType === 'addon') {
                delete selectedAddons[serviceId];
                const addonCard = document.querySelector(`.addon-card[data-service-id="${serviceId}"]`);
                if (addonCard) {
                    addonCard.querySelector('input[type="checkbox"]').checked = false;
                    addonCard.classList.remove('selected');
                }
            }
            updateSummary();
        }
    });

    // Load all initial data, including booked slots, via an AJAX call to bypass any server cache
    loadInitialData();
});
    </script>
</body>
</html>